#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "CFunctions.h"

#define T1_OVERFLOW        0
#define T1_OVERFLOW2       1
#define T5_COUNT_LSB       2
#define T5_COUNT_MSB       3
#define PPSCOUNT           4


void T1Int(void) {                      //set to trigger pin 22 1PPS also, hence odd numbers (62500 x 640 = 40M, toggle on 320)
    ++CFuncRam[PPSCOUNT];               //at start to reduce jitter
    if(CFuncRam[PPSCOUNT]>319){
        CFuncRam[PPSCOUNT]=0;           //reset counter
        LATBINV=_LATB_LATB11_MASK;      //toggle pin 22 RB11
    }
    CFuncRam[T1_OVERFLOW] += 62500;
    if( !CFuncRam[T1_OVERFLOW] )
        ++CFuncRam[T1_OVERFLOW2];
    IFS0bits.T1IF=0;    //clear flag
}
/*
void T5Int(void){               //capture T1 value on T5 edge
    unsigned char if1b, if1a;
    unsigned long long pllcounts;
    mT1IntEnable(0);
    if1b = IFS0bits.T1IF;
    pllcounts = TMR1 | (unsigned long)CFuncRam[T1_OVERFLOW] | (((unsigned long long)CFuncRam[T1_OVERFLOW2]) << 32);
    if1a = IFS0bits.T1IF;
    mT1IntEnable(1);
    if( if1a && !if1b ){pllcounts = (pllcounts & 0xFFFFFFFFFFFF0000UL) + 0x10000;}
    CFuncRam[T5_COUNT_LSB]= pllcounts & 0xFFFFFFFF;
    CFuncRam[T5_COUNT_MSB]= (pllcounts>>32) & 0xFFFFFFFF;
    IFS0bits.T5IF = 0;  //clear flag    
}
*/
__attribute__((noinline)) void getFPC(void *a, void *b, volatile unsigned int *c) {
    *c = (unsigned int) (__builtin_return_address (0) - (b -a)) ;
}

long long int main(long long int* function){
    if( *function == 0 ) {                  //set up 1 as counter, 5 as soft input capture
        volatile unsigned int libAddr;
        getFPC(NULL,&&getFPCLab,&libAddr) ; // warning can be ignored, stupid editor
        getFPCLab: { }
        CFuncT1=(unsigned int)&T1Int + libAddr;
        //CFuncT5=(unsigned int)&T5Int + libAddr;
        CFuncRam[T1_OVERFLOW] = 0;
        CFuncRam[T1_OVERFLOW2] = 0;
        CFuncRam[PPSCOUNT] = 0;                     //increment on interrupt, toggle 1PPS on overflow
        T1CONbits.ON=0;     //reset T1CK is fixed to pin 12 (console RX)
        T1CONbits.TCKPS=0;  //1:1 prescaler
        T1CONbits.TCS=1;    //external source
        T1CONbits.TSYNC=0;  //non-sync input
        PR1 = 62499;       //close to full period, divisor of 40M
        TMR1 = 0;           //reset
        IFS0bits.T1IF=0;    //clear flag
        IEC0bits.T1IE=1;    //enable
        IPC1bits.T1IP=1;    //priority 1

        //T5CONbits.ON=0;     //T5 off
        //T5CONbits.TCKPS=0;  //1:1 prescale
        //T5CONbits.TCS=1;    //external
        //PR5 = 1;            //interrupt every cycle
        //TMR5 = 0;           //reset        
        //T5CKR=3;            //0=p10, 1=p25, 2=p4, 3=p21, 4=p18
        //IFS0bits.T5IF = 0;  //clear flag
        //IEC0bits.T5IE=1;    //enable
        //IPC5bits.T5IP=2;    //priority 2

        T1CONbits.ON=1;     //T1 on
        //T5CONbits.ON=0;     //T5 off
        
    }else if( *function == 1 ) { // read value and zero it
        /*
        unsigned long long pllcounts;
        mT5IntEnable(0);
        pllcounts = (unsigned long)CFuncRam[T5_COUNT_LSB] | (((unsigned long long)CFuncRam[T5_COUNT_MSB]) << 32) ;   
        CFuncRam[T5_COUNT_LSB]=0;
        CFuncRam[T5_COUNT_MSB]=0;
        mT5IntEnable(1);
        return pllcounts;        
         */
    }else if( *function == 2 ) { // read current raw
        unsigned char if1b, if1a;
        unsigned long long pllcounts;
        mT1IntEnable(0);
        if1b = IFS0bits.T1IF;
        pllcounts = TMR1 | (unsigned long)CFuncRam[T1_OVERFLOW] | (((unsigned long long)CFuncRam[T1_OVERFLOW2]) << 32);
        if1a = IFS0bits.T1IF;
        mT1IntEnable(1);
        if( if1a && !if1b ){pllcounts = (pllcounts & 0xFFFFFFFFFFFF0000UL) + 0x10000;}
        return pllcounts;
    }
    return 0;
 }
